package ch.frankel.blog.hibernate.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.usertype.UserType;

import ch.frankel.blog.hibernate.util.DateIntegerType;

/**
 * Entity that shows the use of {@link UserType}.
 * 
 * @author Nicolas Frnkel
 * @since 13 dc. 2009
 */
@Entity
@TypeDef(name = "dateInt", typeClass = DateIntegerType.class)
public class Owner {

    /** Id. */
    private Integer id;

    /** Date that is stored as int in the database. */
    private Date date;

    @Type(type = "dateInt")
    @Column(name = "MYDATE")
    public Date getDate() {

        return date;
    }

    @Id
    public Integer getId() {

        return id;
    }

    public void setDate(Date date) {

        this.date = date;
    }

    public void setId(Integer id) {

        this.id = id;
    }
}
